
-- Rain parameters
kPPS = 40;               -- Number of particles generated per second
kGravity =50 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("smoke");
  SetBlendMode( kBlendAdditive);
  SetNumParticles(300);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(4500);
TestDone = NewTimeout(6000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(2,3), Vec3(2, 3) );
   InitVelocity( "vRange", Vec3(-16,5), Vec3(-50,5) );
   InitScale( "fRange", 0.5, 1.0 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

Gravity(-.15* kGravity);

   Do("move");
   DoAge("iAge");
   DoScale("fScale",
      .1, 2500,
       1, 1500);
   DoColor("cFade",
      Color(1, 1, 1, 1), 400,
      Color(.2, .2, .2, 1));
   Do("expire", 400)
end

